﻿using System;
using Avalonia;
using Avalonia.Logging.Serilog;

namespace itemControllerTest
{
    class Program
    {
        static MainWindow mainWnd = null;

        // Initialization code. Don't use any Avalonia, third-party APIs or any
        // SynchronizationContext-reliant code before AppMain is called: things aren't initialized
        // yet and stuff might break.
        public static void Main(string[] args)
        {
            System.AppDomain.CurrentDomain.ProcessExit += CurrentDomain_ProcessExit;
            Console.CancelKeyPress += Console_CancelKeyPress;

            BuildAvaloniaApp().Start(AppMain, args);
        }

        private static void Console_CancelKeyPress(object sender, ConsoleCancelEventArgs e)
        {
            mainWnd.OnWindowClose();
            e.Cancel = true;
        }
        private static void CurrentDomain_ProcessExit(object sender, EventArgs e)
        {
            mainWnd.OnWindowClose();
        }

        // Avalonia configuration, don't remove; also used by visual designer.
        public static AppBuilder BuildAvaloniaApp()
        { 
            return AppBuilder.Configure<App>().UsePlatformDetect().LogToDebug();
        }

        // Your application's entry point. Here you can initialize your MVVM framework, DI
        // container, etc.
        private static void AppMain(Application app, string[] args)
        {
            mainWnd = new MainWindow();

            app.Run(mainWnd);
        }
    }
}
